/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonDataAnalysisRoutine;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.event.MicroCodeDataEvent0A;
import com.ibm.hwmca.base.pa.event.MicroCodeLevel20a0b;
import com.ibm.hwmca.base.pa.incident.HmcIncident;
import com.ibm.hwmca.base.pa.problem.FailingSystemProblemFilter;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.problem.DuplicateRefcodeProblemFilter;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.TimeProblemFilter;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.CriticalProblem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MicroCodeAnalysisRoutine0A
extends CommonDataAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPAMAART";
    private static final String TRACE_MASKF = "XPAMAARF";
    private static final String TRACE_MASKD = "XPAMAARD";
    private boolean criticalProblem = false;
    private boolean runSeIML = false;
    private boolean runSeDump = false;
    private byte eventClass = (byte)10;
    private short errorId = 0;
    private short errorReason = 0;
    private byte eventType = 0;
    private byte[] logData = null;
    private Date eventTime = null;
    public static final byte EVENT_FROM_C_CODE = 10;
    private Calendar currentCalendar = Calendar.getInstance(UserContext.getCurrentUserContext().getTimeZone(), UserContext.getCurrentUserContext().getLocale());
    private int compRc = 0;
    private boolean isHMC = true;
    private CommonServiceIncident incident = null;

    public MicroCodeAnalysisRoutine0A() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        long unavailable;
        Trace.trace(TRACE_MASKD, "--> analyze()");
        try {
            byte[] bHMCType = SimServer.getSimServer().readSim(5);
            if (bHMCType != null) {
                switch (bHMCType[0]) {
                    case 2: {
                        this.isHMC = true;
                        break;
                    }
                    case 4: {
                        this.isHMC = true;
                        break;
                    }
                    case 1: {
                        this.isHMC = false;
                        break;
                    }
                    case 3: {
                        this.isHMC = false;
                    }
                }
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Exception reading XCPC_STATUS SIM field");
            Trace.trace(TRACE_MASKF, e);
        }
        MicroCodeDataEvent0A ourEvent = (MicroCodeDataEvent0A)event;
        Trace.trace(TRACE_MASKD, "Create a problem");
        CommonProblem aProblem = null;
        try {
            aProblem = this.instantiateProblem(ourEvent);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-- analyze: couldn't create problem: " + e);
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "couldn't create problem: " + e;
            theLog.add((byte)3, dataString);
            theLog.log();
            return;
        }
        HmcIncident anIncident = new HmcIncident();
        this.setIncident(anIncident);
        anIncident.setProblem(aProblem);
        Trace.trace(TRACE_MASKD, "Time of the incident = " + anIncident.getTimestamp().getTime());
        Trace.trace(TRACE_MASKD, "Add some stuff to the problem");
        aProblem.addProblemStatement(new BaseMessageText("XPA1641"));
        aProblem.addCorrectiveActionStatement(new BaseMessageText("XPA3027"));
        aProblem.addRepairImpactStatement(new BaseMessageText("XPA9990"));
        Trace.trace(TRACE_MASKD, "Added BaseMessage to problem");
        Log dataLog = (Log)ourEvent.getData();
        if (dataLog == null) {
            Trace.trace(TRACE_MASKD, "dataLog = null");
        } else {
            Trace.trace(TRACE_MASKD, "dataLog was not null");
        }
        String byteOne = null;
        byteOne = dataLog.getLogClass() == 10 ? "a0" : HexString.toHex(dataLog.getLogClass(), true);
        Trace.trace(TRACE_MASKD, "About to retrieve the Summar_BLOCK_ID");
        byte[] logData = (byte[])dataLog.getLogBlock((byte)-16).getData();
        Trace.trace(TRACE_MASKD, "logData Retrieved " + logData.toString());
        String refcode = byteOne + HexString.toHex(dataLog.getLogType(), true) + HexString.toHex(ourEvent.getErrorId(), true);
        refcode = refcode.toUpperCase();
        Trace.trace(TRACE_MASKD, "refcode to be set is =(" + refcode + ")");
        this.setEventClass(dataLog.getLogClass());
        this.setLogData(logData);
        this.setEventType(dataLog.getLogType());
        this.setErrorId(ourEvent.getErrorId());
        this.setErrorReason(ourEvent.getErrorReason());
        this.setEventTime(dataLog.getTimestamp());
        String extension = "0000" + HexString.toHex(this.getErrorReason(), true);
        extension = extension.toUpperCase();
        Trace.trace(TRACE_MASKD, "refcode to be set is =(" + refcode + ")");
        Trace.trace(TRACE_MASKD, "dataLog.getLogClass() =(" + dataLog.getLogClass() + ")");
        Trace.trace(TRACE_MASKD, "dataLog.getLogType() =(" + dataLog.getLogType() + ")");
        Trace.trace(TRACE_MASKD, "extension to be set is =(" + extension + ")");
        Trace.trace(TRACE_MASKD, "errorId =(" + this.getErrorId() + ")");
        Trace.trace(TRACE_MASKD, "errorReason =(" + this.getErrorReason() + ")");
        Trace.trace(TRACE_MASKD, "errorType =(" + this.getEventType() + ")");
        boolean temp = this.getEventType() == 47;
        Trace.trace(TRACE_MASKD, "errorType = FrameworkLogType.VPDMGR(" + temp + ")");
        temp = this.getErrorId() == 514;
        Trace.trace(TRACE_MASKD, "getErrorId() == 0x0202(" + temp + ")");
        aProblem.setRefcode(refcode);
        aProblem.setExtension(extension);
        Boolean delayed = (Boolean)ourEvent.getMetaData().getMeta("pdc_DELAYED_LOG");
        if (delayed != null) {
            aProblem.setDelayed(delayed);
        }
        this.isEventCritical();
        if (this.isCriticalProblem()) {
            Trace.trace(TRACE_MASKD, "Event is Critical " + this.getEventType());
            this.handleCriticalProblem(aProblem, dataLog);
            return;
        }
        Trace.trace(TRACE_MASKD, "Event is Non Critical " + this.getEventType());
        aProblem.setProblemType("2");
        aProblem.setCategory(1);
        aProblem.setDescription(1641);
        aProblem.setService("Y");
        if (this.isRunSeIML()) {
            this.handleRunSeIml(((CommonServiceEvent)event).getSystem());
        }
        if (this.isRunSeDump()) {
            this.handleRunSeDump();
        }
        if (((unavailable = ourEvent.getUnavailableServices()) & 1L) != 0L) {
            aProblem.setSkipVPD(true);
        }
        if ((unavailable & 2L) != 0L) {
            aProblem.setSkipRSF(true);
        }
        anIncident.setPriority(40.0f);
        this.setProblemTransmitFlag(aProblem);
        this.handlePanelInformation(anIncident, aProblem, dataLog);
        MicroCodeLevel20a0b ml2 = new MicroCodeLevel20a0b(ourEvent.getSource());
        ml2.setData(ourEvent.getData());
        anIncident.setSecondaryEvent(ml2);
        anIncident.addAssociateFile(ourEvent.getAssociatedFileList());
        ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        this.reportIncident(ourEvent, anIncident, cad.getInitialTimeoutEvent(this), cad.getMicrocodeWait());
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    private void isEventCritical() {
        boolean usrerrorid = false;
        int usrerrorreason = 0;
        boolean switchType = false;
        switch (this.getEventType()) {
            case 10: {
                this.setCriticalProblem(true);
                break;
            }
            case 47: {
                if (this.getErrorId() != 512 && this.getErrorId() != 513 && this.getErrorId() != 514 && this.getErrorId() != 515 && this.getErrorId() != 519 && this.getErrorId() != 524 && this.getErrorId() != 546 && this.getErrorId() != 547 && this.getErrorId() != 548 && this.getErrorId() != 549 && this.getErrorId() != 550 && this.getErrorId() != 551 && this.getErrorId() != 555 && this.getErrorId() != 556 && this.getErrorId() != 557 && this.getErrorId() != 558 && this.getErrorId() != 559 && this.getErrorId() != 560 && this.getErrorId() != 561 && this.getErrorId() != 562 && this.getErrorId() != 563 && this.getErrorId() != 565 && this.getErrorId() != 566 && this.getErrorId() != 567 && this.getErrorId() != 568 && this.getErrorId() != 569 && this.getErrorId() != 572 && this.getErrorId() != 573 && this.getErrorId() != 574 && this.getErrorId() != 575 && this.getErrorId() != 576 && this.getErrorId() != 577 && this.getErrorId() != 578 && this.getErrorId() != 579 && this.getErrorId() != 580 && this.getErrorId() != 585 && this.getErrorId() != 586 && this.getErrorId() != 587 && this.getErrorId() != 1536 && this.getErrorId() != 1792) break;
                this.setCriticalProblem(true);
                break;
            }
            case 53: {
                if (this.getErrorId() != 558) break;
                this.setRunSeIML(true);
                break;
            }
            case 61: {
                if (this.getErrorId() != 1036) break;
                this.setRunSeIML(true);
                break;
            }
            case 103: {
                if (this.getErrorId() != 3 || new String(this.getLogData(), 14, 18).equals("IQYP")) {
                    // empty if block
                }
                this.setCriticalProblem(true);
                break;
            }
            case 125: {
                if (this.getErrorId() != 49170 || usrerrorreason != 640) break;
                this.setRunSeIML(true);
                break;
            }
            default: {
                this.setCriticalProblem(false);
            }
        }
    }

    public int getCompRc() {
        return this.compRc;
    }

    public boolean isCriticalProblem() {
        return this.criticalProblem;
    }

    public Calendar getCurrentCalendar() {
        return this.currentCalendar;
    }

    public short getErrorId() {
        return this.errorId;
    }

    public short getErrorReason() {
        return this.errorReason;
    }

    public byte getEventClass() {
        return this.eventClass;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public byte[] getLogData() {
        return this.logData;
    }

    public boolean isRunSeDump() {
        return this.runSeDump;
    }

    public boolean isRunSeIML() {
        return this.runSeIML;
    }

    public void setCompRc(int compRc) {
        this.compRc = compRc;
    }

    public void setCriticalProblem(boolean criticalProblem) {
        this.criticalProblem = criticalProblem;
    }

    public void setCurrentCalendar(Calendar currentCalendar) {
        this.currentCalendar = currentCalendar;
    }

    public void setErrorId(short errorId) {
        this.errorId = errorId;
    }

    public void setErrorReason(short errorReason) {
        this.errorReason = errorReason;
    }

    public void setEventClass(byte eventClass) {
        this.eventClass = eventClass;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventType(byte eventType) {
        this.eventType = eventType;
    }

    public void setLogData(byte[] logData) {
        this.logData = logData;
    }

    public void setRunSeDump(boolean runSeDump) {
        this.runSeDump = runSeDump;
    }

    public void setRunSeIML(boolean runSeIML) {
        this.runSeIML = runSeIML;
    }

    private void handleCriticalProblem(CommonProblem aProblem, Log logData) {
        Trace.trace(TRACE_MASKD, ": Critical ff = " + this.getEventType());
        Trace.trace(TRACE_MASKD, ": usrerrorid = " + this.getErrorId());
        Trace.trace(TRACE_MASKD, ": usrerrorreason " + this.getErrorReason());
        CriticalProblem cp = new CriticalProblem(aProblem.getRefcode(), aProblem.getExtension());
        cp.setPrimaryDataEvent(aProblem.getPrimaryDataEvent());
        cp.postIt();
    }

    private boolean doXP330AReadSimErr() {
        if (this.xsimRead(0, 0, 0) == 1) {
            Trace.trace(TRACE_MASKD, ": STATIS SE/MC SIM ERROR");
            Trace.trace(TRACE_MASKD, ": XP33_0A READ_SEM_ERR_1 RC= 0");
            Trace.trace(TRACE_MASKT, ": <-MicroCodeAnalysis Return after SIM ERR 1");
            return true;
        }
        return false;
    }

    private int xsimRead(int who, int what, int where) {
        return 0;
    }

    private void reallyReboot() {
        Trace.trace(TRACE_MASKD, ": in Really Reboot determination routine");
        if (!this.isHMC && this.isRunSeIML()) {
            int serv_mode = 0;
            if (this.xsimRead(0, serv_mode, this.getCompRc()) == 1) {
                Trace.trace(TRACE_MASKD, ": SERVICE STATE SIM ERROR");
                Trace.trace(TRACE_MASKD, ": XP33_0A_READ_SIM_ERR_0 comp_rc = " + this.getCompRc());
                Trace.trace(TRACE_MASKT, ": <- xp33_0a");
            }
            Trace.trace(TRACE_MASKF, ": SIM_SERVICE_MODE = " + serv_mode);
            if (serv_mode != 0) {
                Trace.trace(TRACE_MASKT, ": SE is in Service Mode, Do not reboot.");
                this.setRunSeIML(false);
            }
        }
    }

    private void handleRunSeIml(PASystem system) {
        List systemProblems = null;
        ArrayList systemProblemsWithIn20 = new ArrayList();
        ArrayList duplicateErrors = new ArrayList();
        try {
            ProblemManager myProblemManager = ProblemManager.getProblemManager();
            systemProblems = myProblemManager.filter(new FailingSystemProblemFilter(system));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (systemProblems != null) {
            TimeProblemFilter timeFilter = new TimeProblemFilter(120000L);
            timeFilter.filter(systemProblemsWithIn20, systemProblems);
            if (systemProblemsWithIn20.size() > 0) {
                DuplicateRefcodeProblemFilter drpf = new DuplicateRefcodeProblemFilter(this.getIncident().getProblem());
                drpf.filter(duplicateErrors, systemProblemsWithIn20);
            }
        }
        if (duplicateErrors != null && duplicateErrors.size() < 2) {
            Trace.trace(TRACE_MASKD, ": XP33_0A_XLOG_RET_ERR comp_rc should signal for a reboot");
            Trace.trace(TRACE_MASKD, ": pastErrors count  = " + duplicateErrors.size());
            Trace.trace(TRACE_MASKT, ": <- xp33_0a");
            return;
        }
    }

    private void handleRunSeDump() {
        Trace.trace(TRACE_MASKD, ": OS2 Dump Refcode: ff = " + this.getEventType());
        Trace.trace(TRACE_MASKD, ": usrerrorid = " + this.getErrorId());
        Trace.trace(TRACE_MASKD, ": usrerrorreason = " + this.getErrorReason());
    }

    private void setProblemTransmitFlag(CommonProblem aProblem) {
        Trace.trace(TRACE_MASKD, "setProblemTransmitFlag()-->");
        switch (this.getEventType()) {
            case 49: 
            case 92: {
                if (this.getErrorId() < 1024 || this.getErrorId() >= 1280) {
                    Trace.trace(TRACE_MASKD, ": Transmit.");
                    aProblem.setTransmit(true);
                    break;
                }
            }
            case -91: 
            case -90: 
            case -68: 
            case 119: {
                Trace.trace(TRACE_MASKD, ": Do not transmit.");
                aProblem.setTransmit(false);
                break;
            }
            default: {
                aProblem.setTransmit(true);
            }
        }
        Trace.trace(TRACE_MASKD, "<--setProblemTransmitFlag()");
    }

    private void setAlertData(CommonProblem aProblem) {
        switch (this.getEventType()) {
            case 49: 
            case 92: {
                if (this.getErrorId() < 1024 || this.getErrorId() >= 1280) break;
            }
            case -91: 
            case -90: 
            case 119: {
                Trace.trace(TRACE_MASKD, ": No alert generated.");
                break;
            }
        }
    }

    private void handlePanelInformation(CommonServiceIncident anIncident, CommonProblem aProblem, Log dataLog) {
        Trace.trace(TRACE_MASKD, "handlePanelInformation()-->");
        if (aProblem.getRefcode().equals("A03A0130")) {
            aProblem.addProblemStatement(new BaseMessageText("XPA2300"));
            aProblem.addCorrectiveActionStatement(new BaseMessageText("XPA2900"));
            aProblem.addRepairImpactStatement(new BaseMessageText("XPA2330"));
        } else {
            if (!this.isHMC) {
                aProblem.addProblemStatement(new BaseMessageText("XPA2910"));
                aProblem.addRepairImpactStatement(new BaseMessageText("XPA2030"));
            } else {
                aProblem.addProblemStatement(new BaseMessageText("XPA2911"));
                aProblem.addRepairImpactStatement(new BaseMessageText("XPA2031"));
            }
            aProblem.addCorrectiveActionStatement(new BaseMessageText("XPA2900"));
        }
        Trace.trace(TRACE_MASKD, "handlePanelInformation()-->");
    }

    public CommonServiceIncident getIncident() {
        return this.incident;
    }

    public void setIncident(CommonServiceIncident incident) {
        this.incident = incident;
    }
}

